﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Text;

namespace VIRP.EFR.BO
{
    [Serializable, DataContract]
    public partial class REFERRAL_EFR_COMPLETE
    {
        #region Fields
        private VIRP.CRS.BO.REFERRAL referral;
        private VIRP.CRS.BO.REFERRAL_REG referralReg;
        private VIRP.CRS.BO.PATIENT patient;
        private VIRP.CRS.BO.PATIENT_REG patientReg;
        private List<VIRP.EFR.BO.REFERRAL_DETAIL> referralDetailList;
        //private List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> _bioWkfCaseActivityList;
        private List<VIRP.EFR.BO.BioFollowUpWorkflowCaseActivity> bioWkfCaseActivityList;
        private List<VIRP.CRS.BO.WKF_CASE> workflowCaseList;
        private List<int> savedWorkflowCaseIdList;
        private List<EfrWorkflowItem> workflowsDataSource;
        private List<KeyValuePair<int, string>> efrWorkflowTypeList;
        private List<KeyValuePair<string, string>> stdReminderDescriptionList;
        private VIRP.CRS.BO.STD_INSTITUTION stdInstitution;
        private int srsEfrNewCasesId;
        private int srsEfrOpenCasesId;
        private int srsEfrIneligible;
        private int srsEfrNoActionRequired;
        private int srsEfrClosedCasesId;
        private int wcsEfrInProcess;
        private string wcsEfrInProcessString;
        private bool iraqAfghanService;

        private string userName = "";
        private int registryId = 0;
        private int referralId = 0;
        private Int32 patientIdFromQueryString;
        #endregion

        #region Constructors
        public REFERRAL_EFR_COMPLETE()
        {
        }
        public REFERRAL_EFR_COMPLETE(string userName, int registryId, Int32 referralId, Int32 patientIdFromQueryString, bool isOriginal)
        {
            this.userName = userName;
            this.registryId = registryId;
            this.referralId = referralId;
            this.patientIdFromQueryString = patientIdFromQueryString;

            List<VIRP.CRS.BO.STD_REGISTRY> sr = VIRP.CRS.BLL.STD_REGISTRYManager.GetItems(this.userName, this.registryId);
            foreach (VIRP.CRS.BO.STD_REGISTRY registry in sr)
            {
                if (registry.CODE == "EFR")
                {
                    this.registryId = registry.ID;
                }
            }

            if (this.referralId == 0)
            {
                this.SetupNewReferral();
            }
            else if (isOriginal)
            {
                this.SetupOriginalReferral();
            }
            else
            {
                this.SetupExistingReferral();
            }

            foreach (VIRP.EFR.BO.REFERRAL_DETAIL rd in this.referralDetailList)
            {
                if (rd.STD_HEALTHFACTOR_ID == 74)
                {
                    this.iraqAfghanService = true;
                    break;
                }
            }

            this.efrWorkflowTypeList = this.GetWorkflowTypeList(this.userName, this.registryId);
            this.stdReminderDescriptionList = this.GetStdReminderDescriptionList(this.userName, this.registryId);

            VIRP.CRS.BO.STD_REFERRALSTS efrNew = VIRP.CRS.BLL.STD_REFERRALSTSManager.GetItemByCode(this.userName, this.registryId, "EFR_NEW");
            VIRP.CRS.BO.STD_REFERRALSTS efrOpen = VIRP.CRS.BLL.STD_REFERRALSTSManager.GetItemByCode(this.userName, this.registryId, "EFR_OPEN_CASES");
            VIRP.CRS.BO.STD_REFERRALSTS efrIneligible = VIRP.CRS.BLL.STD_REFERRALSTSManager.GetItemByCode(this.userName, this.registryId, "EFR_INELIGIBLE");
            VIRP.CRS.BO.STD_REFERRALSTS efrNoaction = VIRP.CRS.BLL.STD_REFERRALSTSManager.GetItemByCode(this.userName, this.registryId, "EFR_NO ACTION REQUIRED");
            VIRP.CRS.BO.STD_REFERRALSTS efrClosed = VIRP.CRS.BLL.STD_REFERRALSTSManager.GetItemByCode(this.userName, this.registryId, "EFR_CLOSED_CASES");
            VIRP.CRS.BO.STD_WKFCASESTS efrWcInProcess = VIRP.CRS.BLL.STD_WKFCASESTSManager.GetItemByCode(this.userName, this.registryId, "IN PROGRESS");
            
            if (efrNew != null)
                this.SrsEfrNewCasesId = efrNew.ID;
            if (efrNew != null)
                this.SrsEfrOpenCasesId = efrOpen.ID;
            if (efrIneligible != null)
                this.SrsEfrIneligible = efrIneligible.ID;
            if (efrNoaction != null)
                this.SrsEfrNoActionRequired = efrNoaction.ID;
            if (efrClosed != null)
                this.SrsEfrClosedCasesId = efrClosed.ID;
            if (efrWcInProcess != null)
            {
                this.WcsEfrInProcess = efrWcInProcess.ID;
                this.WcsEfrInProcessString = efrWcInProcess.NAME;
            }

            this.BuildWorkflowCaseList(this.userName, this.registryId);
        }

        protected void SetupNewReferral()
        {
            this.referral = new CRS.BO.REFERRAL();
            this.referralReg = new CRS.BO.REFERRAL_REG();
            this.patient = new CRS.BO.PATIENT();
            this.patientReg = new CRS.BO.PATIENT_REG();
            this.stdInstitution = new CRS.BO.STD_INSTITUTION();
            this.referralDetailList = new List<REFERRAL_DETAIL>();
            this.workflowCaseList = new List<CRS.BO.WKF_CASE>();
            this.workflowsDataSource = new List<EfrWorkflowItem>();
            this.savedWorkflowCaseIdList = new List<int>();
            this.iraqAfghanService = false;

            this.referral.STD_REGISTRY_ID = this.registryId;

            // there won't be a patient_reg entry, so we need to create that
            this.patient = VIRP.CRS.BLL.PATIENTManager.GetItem(this.userName, this.registryId, this.patientIdFromQueryString);
            this.patientReg = new CRS.BO.PATIENT_REG();

            // The patient_reg will be set up in the Referral page since it has access to the SOA services.
        }

        protected void SetupOriginalReferral()
        {
            // The Original Referral table doesn't map one to one to the VIRP referral table, so we need to do some legwork 
            // to get that set up

            this.referral = new CRS.BO.REFERRAL();
            this.referralReg = new CRS.BO.REFERRAL_REG();
            this.referralDetailList = new List<REFERRAL_DETAIL>();
            this.workflowsDataSource = new List<EfrWorkflowItem>();
            this.savedWorkflowCaseIdList = new List<int>();

            VIRP.EFR.BO.REFERRAL_ORIGINAL referralOriginal = VIRP.EFR.BLL.REFERRAL_ORIGINALManager.GetItemByReferral_ID(this.userName, this.registryId, this.referralId);
            List<VIRP.EFR.BO.REFERRAL_DETAIL_ORIGINAL> referralDetailListOriginal = VIRP.EFR.BLL.REFERRAL_ORIGINALManager.GetOriginalHealthFactorsComplete(this.userName, this.registryId, this.referralId);

            this.referralReg.VAMC_CONTACT_NAME = referralOriginal.VAMC_CONTACT_NAME;
            this.referralReg.VAMC_CONTACT_EMAIL = referralOriginal.VAMC_CONTACT_EMAIL;
            this.referralReg.VAMC_CONTACT_FAX = referralOriginal.VAMC_CONTACT_FAX;
            this.referralReg.VAMC_CONTACT_PHONE = referralOriginal.VAMC_CONTACT_PHONE;

            this.referralReg.PROVIDER_EMAIL = referralOriginal.PROVIDER_EMAIL;
            this.referralReg.PROVIDER_NAME = referralOriginal.PROVIDER_NAME;
            this.referralReg.PROVIDER_PHONE = referralOriginal.PROVIDER_PHONE;
            this.referralReg.PROVIDER_FAX = referralOriginal.PROVIDER_FAX;
            this.referralReg.PROVIDER_ADDRESS_LINE1 = referralOriginal.PROVIDER_ADDRESS_LINE1;
            this.referralReg.PROVIDER_ADDRESS_LINE2 = referralOriginal.PROVIDER_ADDRESS_LINE2;
            this.referralReg.PROVIDER_ADDRESS_LINE3 = referralOriginal.PROVIDER_ADDRESS_LINE3;
            this.referralReg.PROVIDER_CITY = referralOriginal.PROVIDER_CITY;
            this.referralReg.PROVIDER_STATE = referralOriginal.PROVIDER_STATE;
            this.referralReg.PROVIDER_COUNTRY = referralOriginal.PROVIDER_COUNTRY;
            this.referralReg.PROVIDER_POSTAL_CODE = referralOriginal.PROVIDER_POSTAL_CODE;

            //referral institution information 
            this.referralReg.ADDRESS_LINE1 = referralOriginal.ADDRESS_LINE1;
            this.referralReg.ADDRESS_LINE2 = referralOriginal.ADDRESS_LINE2;
            this.referralReg.ADDRESS_LINE3 = referralOriginal.ADDRESS_LINE3;
            this.referralReg.CITY = referralOriginal.CITY;
            this.referralReg.POSTAL_CODE = referralOriginal.POSTAL_CODE;
            this.referralReg.STATE = referralOriginal.STATE;
            this.referralReg.COUNTRY = referralOriginal.COUNTRY;
            this.referral.REFERRAL_ID = referralOriginal.REFERRAL_ID;
            this.referral.CREATED = referralOriginal.CREATED;
            this.referral.CREATEDBY = referralOriginal.CREATEDBY;
            this.referral.STD_INSTITUTION_ID = referralOriginal.STD_INSTITUTION_ID;
            this.referral.PATIENT_ID = referralOriginal.PATIENT_ID;
            this.referral.REFERRAL_DATE = referralOriginal.REFERRAL_DATE;
            this.referral.STD_REGISTRY_ID = referralOriginal.STD_REGISTRY_ID;
            this.referral.STD_REFERRALSTS_ID = referralOriginal.STD_REFERRALSTS_ID;

            // Now the health factors
            foreach (VIRP.EFR.BO.REFERRAL_DETAIL_ORIGINAL rdo in referralDetailListOriginal)
            {
                VIRP.EFR.BO.REFERRAL_DETAIL rd = new REFERRAL_DETAIL();

                rd.REFERRAL_ID = this.referralId;
                rd.CREATEDBY = rdo.CREATEDBY;
                rd.CREATED = rdo.CREATED;
                rd.UPDATEDBY = rdo.UPDATEDBY;
                rd.COMMENT_TEXT = rdo.COMMENT_TEXT;
                rd.HF_VISITID = rdo.HF_VISITID;
                rd.VISIT_IEN = rdo.VISIT_IEN;
                rd.ICN = rdo.ICN;
                rd.Clinic = rdo.Clinic;
                rd.CurSta3n = rdo.CurSta3n;
                rd.AdmParent_Key = rdo.AdmParent_Key;
                rd.STD_HEALTHFACTOR_ID = rdo.STD_HEALTHFACTOR_ID;
                rd.HF_IEN = rdo.HF_IEN;
                rd.DFN = rdo.DFN;

                this.referralDetailList.Add(rd);
            }

            this.SetupCommentReferralElements();
        }

        protected void SetupExistingReferral()
        {
            this.referral = VIRP.CRS.BLL.REFERRALManager.GetItem(this.userName, this.registryId, this.referralId);
            this.referralReg = VIRP.CRS.BLL.REFERRAL_REGManager.GetItem(this.userName, this.registryId, this.referralId);

            this.SetupCommentReferralElements();
            this.SetupBioWorkflows();

            this.referralDetailList = VIRP.EFR.BLL.REFERRALManager.GetHealthFactorsComplete(this.userName, this.registryId, this.referralId);
            this.workflowsDataSource = new List<EfrWorkflowItem>();
            this.savedWorkflowCaseIdList = new List<int>();
        }

        protected void SetupCommentReferralElements()
        {
            this.patient = VIRP.CRS.BLL.PATIENTManager.GetItem(this.userName, this.registryId, this.Referral.PATIENT_ID);
            this.patientReg = VIRP.CRS.BLL.PATIENT_REGManager.GetItem(this.userName, this.registryId, this.Referral.PATIENT_ID);
            this.bioWkfCaseActivityList = new List<BioFollowUpWorkflowCaseActivity>();

            if (this.Referral.STD_INSTITUTION_ID != null)
            {
                this.stdInstitution = VIRP.CRS.BLL.STD_INSTITUTIONManager.GetItemComplete(this.userName, this.registryId, (int)this.Referral.STD_INSTITUTION_ID);
            }
        }

        protected void SetupBioWorkflows()
        {
            List<CRS.BO.WKF_CASE_ACTIVITY> tmpBioWkfCaseActivityList = VIRP.EFR.BLL.REFERRALManager.GetBioFollowups(this.userName, this.registryId, this.referralId);

            foreach (CRS.BO.WKF_CASE_ACTIVITY wca in tmpBioWkfCaseActivityList)
            {
                EFR.BO.BioFollowUpWorkflowCaseActivity bwca = new BioFollowUpWorkflowCaseActivity();
                bwca.CaseActivityId = wca.WKF_CASE_ACTIVITY_ID;
                bwca.DueDate = wca.FOLLOWUP_PLAN_DATE.HasValue ? wca.FOLLOWUP_PLAN_DATE.Value.ToString("d") : String.Empty;

                this.bioWkfCaseActivityList.Add(bwca);
            }
        }

        public void BuildWorkflowCaseList(string pUserName, int pRegistryId)
        {
            Int32 referralId = this.Referral.REFERRAL_ID;
            this.savedWorkflowCaseIdList.Clear();
            this.workflowsDataSource.Clear();

            if (referralId > 0)
            {
                this.workflowCaseList = VIRP.CRS.BLL.WKF_CASEManager.GetItemsByReferral(pUserName, pRegistryId, referralId);
            }

            List<VIRP.CRS.BO.STD_WKFCASESTS> stdWkfCaseStsList = VIRP.CRS.BLL.STD_WKFCASESTSManager.GetItems(pUserName, pRegistryId);

            foreach (VIRP.CRS.BO.WKF_CASE wc in this.workflowCaseList)
            {
                this.savedWorkflowCaseIdList.Add(wc.WKF_CASE_ID);

                foreach (KeyValuePair<int, string> wtl in this.efrWorkflowTypeList)
                {
                    if (wc.STD_WKFCASETYPE_ID == wtl.Key)
                    {
                        foreach (VIRP.CRS.BO.STD_WKFCASESTS wcs in stdWkfCaseStsList)
                        {
                            if (wcs.ID == wc.STD_WKFCASESTS_ID)
                            {
                                this.workflowsDataSource.Add(new EfrWorkflowItem(wc.WKF_CASE_ID, wtl.Value, wcs.NAME, wc.UPDATED.ToString()));
                                break;
                            }
                        }
                    }
                }
            }
        }

        #endregion

        #region Properties

        public VIRP.CRS.BO.REFERRAL Referral
        {
            get { return this.referral; }
            set { this.referral = value; }
        }

        public VIRP.CRS.BO.REFERRAL_REG Referral_reg
        {
            get { return this.referralReg; }
            set { this.referralReg = value; }
        }

        public VIRP.CRS.BO.PATIENT Patient
        {
            get { return this.patient; }
            set { this.patient = value; }
        }

        public VIRP.CRS.BO.PATIENT_REG Patient_reg
        {
            get { return this.patientReg; }
            set { this.patientReg = value; }
        }

        public List<VIRP.EFR.BO.REFERRAL_DETAIL> ReferralDetailList
        {
            get { return this.referralDetailList; }
            set { this.referralDetailList = value; }
        }

        public List<VIRP.EFR.BO.BioFollowUpWorkflowCaseActivity> BioWkfCaseActivityList
        {
            get { return this.bioWkfCaseActivityList; }
            set { this.bioWkfCaseActivityList = value; }
        }

        public List<VIRP.CRS.BO.WKF_CASE> WorkflowCaseList
        {
            get { return this.workflowCaseList; }
            set { this.workflowCaseList = value; }
        }

        public List<int> SavedWorkflowCaseIdList
        {
            get { return this.savedWorkflowCaseIdList; }
            set { this.savedWorkflowCaseIdList = value; }
        }

        public List<EfrWorkflowItem> WorkflowsDataSource
        {
            get { return this.workflowsDataSource; }
            set { this.workflowsDataSource = value; }
        }

        public List<KeyValuePair<int, string>> EfrWorkflowTypeList
        {
            get { return this.efrWorkflowTypeList; }
            set { this.efrWorkflowTypeList = value; }
        }

        public List<KeyValuePair<string, string>> StdReminderDescriptionList
        {
            get { return this.stdReminderDescriptionList; }
            set { this.stdReminderDescriptionList = value; }
        }

        public VIRP.CRS.BO.STD_INSTITUTION StdInstitution
        {
            get { return this.stdInstitution; }
            set { this.stdInstitution = value; }
        }

        public int SrsEfrNewCasesId
        {
            get { return this.srsEfrNewCasesId; }
            set { this.srsEfrNewCasesId = value; }
        }

        public int SrsEfrOpenCasesId
        {
            get { return this.srsEfrOpenCasesId; }
            set { this.srsEfrOpenCasesId = value; }
        }

        public int SrsEfrIneligible
        {
            get { return this.srsEfrIneligible; }
            set { this.srsEfrIneligible = value; }
        }

        public int SrsEfrNoActionRequired
        {
            get { return this.srsEfrNoActionRequired; }
            set { this.srsEfrNoActionRequired = value; }
        }

        public int WcsEfrInProcess
        {
            get { return this.wcsEfrInProcess; }
            set { this.wcsEfrInProcess = value; }
        }
        public string WcsEfrInProcessString
        {
            get { return this.wcsEfrInProcessString; }
            set { this.wcsEfrInProcessString = value; }
        }

        public int SrsEfrClosedCasesId
        {
            get { return this.srsEfrClosedCasesId; }
            set { this.srsEfrClosedCasesId = value; }
        }

        public bool IraqAfghanService
        {
            get { return this.iraqAfghanService; }
            set { this.iraqAfghanService = value; }
        }
        #endregion

        #region Methods

        public void Save(string pUserName, int pRegistryId, string hfids, string EFPComment, string BETComment, string AIComment, string SCIComment)
        {
            int refId = 0;
            bool isNew = false;

            if (this.referral.REFERRAL_ID == 0)
            {
                isNew = true;
                VIRP.CRS.BLL.PATIENT_REGManager.Save(pUserName, pRegistryId, this.patientReg);
            }

            refId = VIRP.CRS.BLL.REFERRALManager.Save(pUserName, pRegistryId, this.Referral);

            if (refId > 0 && this.Referral_reg.REFERRAL_ID == 0)
            {
                this.Referral.REFERRAL_ID = refId;
                this.Referral_reg.REFERRAL_ID = refId;
            }

            VIRP.CRS.BLL.REFERRAL_REGManager.Save(pUserName, pRegistryId, this.Referral_reg);

            VIRP.CRS.BLL.REFERRALManager.SaveHealthFactors(pUserName, pRegistryId, this.Referral.REFERRAL_ID, hfids, EFPComment, BETComment, AIComment, SCIComment);

            // Only save new workflows
            foreach (VIRP.CRS.BO.WKF_CASE wc in this.WorkflowCaseList)
            {
                if (!this.savedWorkflowCaseIdList.Contains(wc.WKF_CASE_ID))
                {
                    if (wc.REFERRAL_ID == 0)
                    {
                        wc.REFERRAL_ID = refId;
                    }

                    VIRP.EFR.BLL.WKF_CASEManager.Save(pUserName, pRegistryId, wc);
                }
            }

            //foreach(VIRP.CRS.BO.WKF_CASE_ACTIVITY wca in this.bioWkfCaseActivityList)
            //{
            //    VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(_userName, _registryId, wca);
            //}

            this.BuildWorkflowCaseList(pUserName, pRegistryId);

            if (isNew)
            {
                this.SaveOriginalReferral(pUserName, pRegistryId, hfids, EFPComment, BETComment, AIComment, SCIComment);
            }
        }

        protected void SaveOriginalReferral(string pUserName, int pRegistryId, string hfids, string EFP_Comment, string BET_Comment, string AI_Comment, string SCI_Comment)
        {
            // The Original Referral table doesn't map one to one to the VIRP referral table, so we need to do some legwork 
            // to get that set up
            VIRP.EFR.BO.REFERRAL_ORIGINAL referralOriginal = new VIRP.EFR.BO.REFERRAL_ORIGINAL();
            
            referralOriginal.REFERRAL_ID = this.referral.REFERRAL_ID;
            referralOriginal.CREATED = this.referral.CREATED;
            referralOriginal.CREATEDBY = this.referral.CREATEDBY;
            referralOriginal.UPDATED = this.referral.UPDATED;
            referralOriginal.UPDATEDBY = this.referral.UPDATEDBY;
            referralOriginal.InsertedDate = DateTime.Now;
            referralOriginal.STD_INSTITUTION_ID = this.referral.STD_INSTITUTION_ID;
            referralOriginal.PATIENT_ID = this.referral.PATIENT_ID;
            referralOriginal.REFERRAL_DATE = this.referral.REFERRAL_DATE;
            referralOriginal.REVIEW_BY = this.referral.REVIEW_BY;
            referralOriginal.REVIEW_DATE = this.Referral.REVIEW_DATE;
            referralOriginal.STD_REGISTRY_ID = this.referral.STD_REGISTRY_ID;
            referralOriginal.STD_REFERRALSTS_ID = this.referral.STD_REFERRALSTS_ID;

            referralOriginal.VAMC_CONTACT_NAME = this.referralReg.VAMC_CONTACT_NAME;
            referralOriginal.VAMC_CONTACT_EMAIL = this.referralReg.VAMC_CONTACT_EMAIL;
            referralOriginal.VAMC_CONTACT_FAX = this.referralReg.VAMC_CONTACT_FAX;
            referralOriginal.VAMC_CONTACT_PHONE = this.referralReg.VAMC_CONTACT_PHONE;

            referralOriginal.PROVIDER_EMAIL = this.referralReg.PROVIDER_EMAIL;
            referralOriginal.PROVIDER_NAME = this.referralReg.PROVIDER_NAME;
            referralOriginal.PROVIDER_PHONE = this.referralReg.PROVIDER_PHONE;
            referralOriginal.PROVIDER_FAX = this.referralReg.PROVIDER_FAX;
            referralOriginal.PROVIDER_ADDRESS_LINE1 = this.referralReg.PROVIDER_ADDRESS_LINE1;
            referralOriginal.PROVIDER_ADDRESS_LINE2 = this.referralReg.PROVIDER_ADDRESS_LINE2;
            referralOriginal.PROVIDER_ADDRESS_LINE3 = this.referralReg.PROVIDER_ADDRESS_LINE3;
            referralOriginal.PROVIDER_CITY = this.referralReg.PROVIDER_CITY;
            referralOriginal.PROVIDER_STATE = this.referralReg.PROVIDER_STATE;
            referralOriginal.PROVIDER_COUNTRY = this.referralReg.PROVIDER_COUNTRY;
            referralOriginal.PROVIDER_POSTAL_CODE = this.referralReg.PROVIDER_POSTAL_CODE;

            referralOriginal.ADDRESS_LINE1 = this.referralReg.ADDRESS_LINE1;
            referralOriginal.ADDRESS_LINE2 = this.referralReg.ADDRESS_LINE2;
            referralOriginal.ADDRESS_LINE3 = this.referralReg.ADDRESS_LINE3;
            referralOriginal.CITY = this.referralReg.CITY;
            referralOriginal.POSTAL_CODE = this.referralReg.POSTAL_CODE;
            referralOriginal.STATE = this.referralReg.STATE;
            referralOriginal.COUNTRY = this.referralReg.COUNTRY;

            int i = VIRP.EFR.BLL.REFERRAL_ORIGINALManager.Save(pUserName, pRegistryId, referralOriginal);

            int j = VIRP.EFR.BLL.REFERRAL_ORIGINALManager.SaveOriginalHealthFactors(pUserName, pRegistryId, this.Referral.REFERRAL_ID, hfids, EFP_Comment, BET_Comment, AI_Comment, SCI_Comment);
        }

        public void PushToWorkingReferral(string hfids, string EFP_Comment, string BET_Comment, string AI_Comment, string SCI_Comment, int workingRefId)
        {
            VIRP.CRS.BO.REFERRAL workingReferral = VIRP.CRS.BLL.REFERRALManager.GetItem(this.userName, this.registryId, workingRefId);
            VIRP.CRS.BO.REFERRAL_REG workingReferral_Reg = VIRP.CRS.BLL.REFERRAL_REGManager.GetItem(this.userName, this.registryId, workingRefId);

            // Setup the workingReferral info
            workingReferral.COMMENT_TEXT = this.referral.COMMENT_TEXT;
            workingReferral.CREATED = this.referral.CREATED;
            workingReferral.CREATEDBY = workingReferral.CREATEDBY + "(" + this.referral.REFERRAL_ID.ToString() + ")";
            workingReferral.CREATEDSOURCE = this.referral.CREATEDSOURCE;
            workingReferral.REVIEW_BY = this.referral.REVIEW_BY;
            workingReferral.REVIEW_DATE = this.referral.REVIEW_DATE;

            workingReferral_Reg.PROVIDER_ID_NUMBER = this.referralReg.PROVIDER_ID_NUMBER;
            workingReferral_Reg.PROVIDER_NAME = this.referralReg.PROVIDER_NAME;
            workingReferral_Reg.PROVIDER_PHONE = this.referralReg.PROVIDER_PHONE;
            workingReferral_Reg.PROVIDER_EMAIL = this.referralReg.PROVIDER_EMAIL;
            workingReferral_Reg.CREATEDBY = workingReferral_Reg.CREATEDBY + "(" + this.referral.REFERRAL_ID.ToString() + ")";
            workingReferral_Reg.ADDRESS_LINE1 = this.referralReg.ADDRESS_LINE1;
            workingReferral_Reg.ADDRESS_LINE2 = this.referralReg.ADDRESS_LINE2;
            workingReferral_Reg.ADDRESS_LINE3 = this.referralReg.ADDRESS_LINE3;
            workingReferral_Reg.CITY = this.referralReg.CITY;
            workingReferral_Reg.COUNTRY = this.referralReg.COUNTRY;
            workingReferral_Reg.COUNTY = this.referralReg.COUNTY;
            workingReferral_Reg.POSTAL_CODE = this.referralReg.POSTAL_CODE;
            workingReferral_Reg.STATE = this.referralReg.STATE;
            workingReferral_Reg.VAMC_CONTACT_EMAIL = this.referralReg.VAMC_CONTACT_EMAIL;
            workingReferral_Reg.VAMC_CONTACT_NAME = this.referralReg.VAMC_CONTACT_NAME;
            workingReferral_Reg.VAMC_CONTACT_PHONE = this.referralReg.VAMC_CONTACT_PHONE;
            workingReferral_Reg.ZIP_PLUS_4 = this.referralReg.ZIP_PLUS_4;
            workingReferral_Reg.VAMC_CONTACT_FAX = this.referralReg.VAMC_CONTACT_FAX;
            workingReferral_Reg.PROVIDER_ADDRESS_LINE1 = this.referralReg.PROVIDER_ADDRESS_LINE1;
            workingReferral_Reg.PROVIDER_ADDRESS_LINE2 = this.referralReg.PROVIDER_ADDRESS_LINE2;
            workingReferral_Reg.PROVIDER_ADDRESS_LINE3 = this.referralReg.PROVIDER_ADDRESS_LINE3;
            workingReferral_Reg.PROVIDER_CITY = this.referralReg.PROVIDER_CITY;
            workingReferral_Reg.PROVIDER_STATE = this.referralReg.PROVIDER_STATE;
            workingReferral_Reg.PROVIDER_COUNTY = this.referralReg.PROVIDER_COUNTY;
            workingReferral_Reg.PROVIDER_COUNTRY = this.referralReg.PROVIDER_COUNTRY;
            workingReferral_Reg.PROVIDER_POSTAL_CODE = this.referralReg.PROVIDER_POSTAL_CODE;
            workingReferral_Reg.PROVIDER_ZIP_PLUS_4 = this.referralReg.PROVIDER_ZIP_PLUS_4;
            workingReferral_Reg.PROVIDER_FAX = this.referralReg.PROVIDER_FAX;
            workingReferral_Reg.REVIEW_BY = this.referralReg.REVIEW_BY;
            workingReferral_Reg.REVIEW_DATE = this.referralReg.REVIEW_DATE;

            // Now save everything

            VIRP.CRS.BLL.REFERRALManager.Save(this.userName, this.registryId, workingReferral);
            VIRP.CRS.BLL.REFERRAL_REGManager.Save(this.userName, this.registryId, workingReferral_Reg);
            VIRP.CRS.BLL.REFERRALManager.SaveHealthFactors(this.userName, this.registryId, workingReferral.REFERRAL_ID, hfids, EFP_Comment, BET_Comment, AI_Comment, SCI_Comment);
        }

        public List<KeyValuePair<int, string>> GetWorkflowTypeList(string pUserName, int pRegistryId)
        {
            List<KeyValuePair<int, string>> objReturn = new List<KeyValuePair<int, string>>();

            List<VIRP.CRS.BO.STD_WKFCASETYPE> wctlist = VIRP.CRS.BLL.STD_WKFCASETYPEManager.GetItems(pUserName, pRegistryId);

            foreach (VIRP.CRS.BO.STD_WKFCASETYPE wct in wctlist)
            {
                if (wct.CODE == "BIOLOGICAL MONITORING" 
                    || wct.CODE == "FRAGMENT ANALYSIS")
                {
                    objReturn.Add(new KeyValuePair<int, string>(wct.ID, wct.CODE));
                }
            }

            return objReturn;
        }

        protected List<KeyValuePair<string, string>> GetStdReminderDescriptionList(string pUserName, int pRegistryId)
        {
            List<KeyValuePair<string, string>> objReturn = new List<KeyValuePair<string, string>>();

            List<VIRP.CRS.BO.STD_REMINDERCLASS> srclist = VIRP.CRS.BLL.STD_REMINDERCLASSManager.GetItems(pUserName, pRegistryId);

            foreach (VIRP.CRS.BO.STD_REMINDERCLASS src in srclist)
            {
                objReturn.Add(new KeyValuePair<string, string>(src.CODE, src.DESCRIPTION_TEXT));
            }

            return objReturn;
        }

        public string GetStdReminderClassDescription(string code)
        {
            string retValue = "";

            foreach (KeyValuePair<string, string> kvp in this.stdReminderDescriptionList)
            {
                if (kvp.Key == code)
                {
                    retValue = kvp.Value;
                    break;
                }
            }

            return retValue;
        }
        #endregion
    }
}
